document.addEventListener("DOMContentLoaded", function () {
  const banner = document.getElementById('cookie-banner');
  const acceptBtn = document.getElementById('accept-btn');
  const declineBtn = document.getElementById('decline-btn');

  // Show the banner only if cookies haven't been accepted yet
  if (localStorage.getItem('cookies-accepted') !== 'true') {
    banner.style.display = 'flex'; // Flex to match the layout
  }

  acceptBtn.addEventListener('click', function () {
    localStorage.setItem('cookies-accepted', 'true');
    banner.style.display = 'none';
  });

  declineBtn.addEventListener('click', function () {
    localStorage.setItem('cookies-accepted', 'false');
    banner.style.display = 'none';
  });
});


